//Generate XOR funcion for bipolar  inputs and targets using madaline network
//     Truth table for XOR gate
//      X1    X2    Y
//      -1    -1    -1
//      -1     1     1
//       1    -1     1
//       1     1    -1           (Bipolar   (1,-1))


clc;
clear;
x=[1 1 -1 -1;1 -1 1 -1];    //input
t=[-1 1 1 -1];          //target
//assuming initial weight matrix and bias
w=[0.05 0.1;0.2 0.2];
b1=[0.3 0.15];
v=[0.5 0.5];
b2=0.5;
con=1;
alpha=0.5;
epoch=0;
while con
    con=0;
    for i=1:4
        for j=1:2
            zin(j)=b1(j)+x(1,i)*w(1,j)+x(2,i)*w(2,j);      //neural functin output
            if zin(j)>=0 then
                z(j)=1;
            else
                z(j)=-1;
            end
        end
        yin=b2+z(1)*v(1)+z(2)*v(2);
        if yin>=0 then
            y=1;
        else
            y=-1;
        end
        if y~=t(i) then
            con=1;
            if t(i)==1 then 
                if abs(zin(1))>abs(zin(2)) then
                    k=2;
                else 
                    k=1;
                end
                b1(k)=b1(k)+alpha*(1-zin(k));       //upgrading bias
                w(1:2,k)=w(1:2,k)+alpha*(1-zin(k))*x(1:2,i);     //upgrading weight
            else 
                for k=1:2
                    if zin(k)>0 then
                        b1(k)=b1(k)+alpha*(-1-zin(k));      //upgrading bias
                        w(1:2,k)=w(1:2,k)+alpha*(-1-zin(k))*x(1:2,i);     //upgrading weight
                        end
                    end
                end
                            end
        end
        epoch=epoch+1;
    end

disp('Weight matrix of hidden layer');
disp(w);
disp('Bias');
disp(b1);
disp('Total epoch');
disp(epoch);
